#if !defined(__LINE__FORMAT__HEADER__INCLUDED__)
#define __LINE__FORMAT__HEADER__INCLUDED__

#include "Types.h"

/**
 * This class intended to format lines in filelist files (like files.bbs) according to
 * the specified format
 */
class CLineFormat {
public:
    CLineFormat() {}
    CLineFormat(const tstring& aFormat);
    virtual ~CLineFormat() {}
    /**
     * Sets new format for future use
     */
    virtual void setFormat(const tstring& aFormat);
	/**
	 * Gets current format
	 */
	virtual tstring getFormat() { return format; }
    /**
     * Returns result of applying of previously set format to the name, description
     * and size of the file
     */
    tstring apply(const tstring& name, const tstring& desc, filesize_t size);
protected:
    /**
     * We'll use the same structure to describe each type of the field
     */
    class CFormatField {
	public:
        int     type;
        tstring value;
        int     width;
        int     precision;
        int     modificator;
        enum fieldTypes {
			UNKNOWN,
            DATA,
            NAME,
            SIZE_BYTES,
            SIZE_SEPARATED_BYTES,
            SIZE_KBYTES,
            SIZE_SEPARATED_KBYTES,
            SIZE_MBYTES,
            SIZE_SEPARATED_MBYTES,
			AUTOSIZE,
			SEPARATED_AUTOSIZE,
            DESCRIPTION,
			MULTILINE_DESCRIPTION
        };
        enum modificators {
			NONE,
            UPPERCASE,
            LOWERCASE
        };
    };
    tstring                 format;
    vector<CFormatField>    fields;
    /**
     * Parses format and stores result as vector of fields
     */
    virtual void parse();
	/**
	 * Gets size as string representing size in bytes
	 */
	virtual tstring bytes(filesize_t size);
	/**
	 * Gets size as string representing size in kbytes with 'K' appended
	 */
	virtual tstring kbytes(filesize_t size);
	/**
	 * Gets size as string representing size in mbytes with 'M' appended
	 */
	virtual tstring mbytes(filesize_t size);
	/**
	 * Gets size as string; representation (byte, kbytes, mbytes) depends
	 * on size: < 1024 - bytes, < 1024k - kbytes, in other case mbytes
	 */
	virtual tstring autosize(filesize_t size);
	/**
	 * Separates size string by adding ',' into the integer part
	 */
	virtual tstring separate(const tstring& size);
	/**
	 * Resizes (without truncating) string; width sign defines alignment:
	 * + for left aligned value, - for right
	 */
	virtual tstring resize(const tstring& value, int width);
	/**
	 * Truncates string using specified precision:
	 * when precision above zero, right part will be truncated
	 * and, consequently, when precision below zero, left part will be truncated
	 */
	virtual tstring truncate(const tstring& value, int precision);
	/**
	 * Changes case of string; modificator cane be 
	 * either CFormatField::UPPERCASE or CFormatField::LOWERCASE
	 */
	virtual tstring changeCase(const tstring& value, int modificator);
	/**
	 * Makes value word-separated in a window with a specified width and offset
	 * from the start of the line; used for preparing multiline descriptions
	 */
	virtual tstring makeWindow(const tstring& value, int width, int offset);
};

#endif // !defined(__LINE__FORMAT__HEADER__INCLUDED__)
